CREATE
    (bradley:User {name:'Bradley', surname:'Green', age:24, city:'Los Angeles'}),
    (matthew:User {name:'Matthew', surname:'Cooper', age:36, city:'Los Angeles'}),
    (lisa:User {name:'Lisa', surname:'Adams', age:15, city:'New York'}),
    (annie:User {name:'Annie', surname:'Behr', age:25, city:'Chicago'}),
    (ripley:User {name:'Ripley', surname:'Aniston', city:'Los Angeles'}),
    (john:User {name:'John', surname:'Goodman', age:34, city:'New York'}),
    (amy:User {name:'Amy', surname:'Cooper', age:22}),
    (mark:User {name:'Mark', surname:'McAdams', age:17, city:'Los Angeles'}),
    (dennis:User {name:'Dennis', surname:'Lemon', age:42, city:'Los Angeles'}),
//FRIEND
    (bradley)-[:FRIEND]->(matthew),
    (bradley)-[:FRIEND]->(ripley),
    (bradley)-[:FRIEND]->(john),
    (matthew)-[:FRIEND]->(bradley),
    (lisa)-[:FRIEND]->(matthew),
    (lisa)-[:FRIEND]->(annie),
    (annie)-[:FRIEND]->(lisa),
    (annie)-[:FRIEND]->(matthew),
    (annie)-[:FRIEND]->(ripley),
(music:Interest {name : 'music'}),
(sports:Interest {name : 'sports'}),
(dance:Interest {name : 'dance'}),
//INTEREST
    (bradley)-[:INTEREST]->(music),
    (bradley)-[:INTEREST]->(dance),
    (john)-[:INTEREST]->(dance),
    (matthew)-[:INTEREST]->(sports),
    (lisa)-[:INTEREST]->(music),
    (lisa)-[:INTEREST]->(dance),
    (annie)-[:INTEREST]->(sports),
    (annie)-[:INTEREST]->(music),
    (ripley)-[:INTEREST]->(music),
    (ripley)-[:INTEREST]->(dance),
    (amy)-[:INTEREST]->(sports),
    (amy)-[:INTEREST]->(dance),
    (mark)-[:INTEREST]->(music),
    (mark)-[:INTEREST]->(dance),
//STATUS
(st1:Status { text : 'I am sleeping', date:'1234'}),
(st2:Status { text : 'Going to ibiza', date:'1345'}),
(st3:Status { text : 'Added mark as friend', date:'1695'}),
(st4:Status { text : 'Going to college', date:'1700'}),
(st5:Status { text : 'Eating pizza', date:'1567'}),
(st6:Status { text : 'drinking coffee', date:'2000'}),

// STATUS Updates
(bradley)-[:STATUS]->(st1),
(bradley)-[:STATUS]->(st2),
(matthew)-[:STATUS]->(st3),
(lisa)-[:STATUS]->(st4),
(lisa)-[:STATUS]->(st5),
(annie)-[:STATUS]->(st6),
//Places
(pl1:Place { type: 'Disco'}),
(pl2:Place { type : 'Coffee bar'}),
(pl3:Place { type : 'Church'}),
(pl4:Place { type : 'College'}),
(pl5:Place { type : 'pizza Corner'}),
(pl6:Place { type : 'Stadium'}),
//VISITED
(Bradley)-[:VISITED {times:5} ]-> (pl1),
(Bradley)-[:VISITED {times:1} ]-> (pl3),
(lisa)-[:VISITED {times:2} ]-> (pl1),
(lisa)-[:VISITED {times:3} ]-> (pl2),
//RATED
(Bradley)-[:RATED {rating:5.0} ]-> (pl1),
(Bradley)-[:RATED {rating:4.8} ]-> (pl3),
(lisa)-[:RATED {rating:5.0} ]-> (pl1),
(lisa)-[:RATED {rating:4.8} ]-> (pl3)